<style>
    .headlap {
        text-align: center;
    }

    .headlap h3 {
        font-weight: 900;
    }

    .headlap h5 {
        font-weight: 800;
        color: red;
    }

    table.lap {
        width: 100%;
        border: 1px solid;
    }

    .lap tr th {
        border: 1px solid;
        border-color: rgb(126, 124, 124);
        text-align: center;
        background-color: rgb(22, 128, 226);
        color: white;
    }

    .lap tr td {
        border: 1px solid;
        border-color: rgb(126, 124, 124);
        font-size: 15px;
        text-align: left;
        padding: 3px;
    }

    @media print {

        @page {
            margin: 20px;
            size: auto;
        }

        .lap tr th {
            border: 1px solid;
            border-color: rgb(126, 124, 124);
            text-align: center;
            background-color: rgb(115, 115, 245);
            color: white;
            font-size: 10pt;
        }

        .lap tr td {
            border: 1px solid;
            border-color: rgb(126, 124, 124);
            font-size: 12px;
        }
    }
</style>
<div class="headlap">
    <h3>LAPORAN DATA PENJUALAN <br>{{ $data['jns'] }} {{ $data['via'] }}
        @if ($data['jns'] != '')
            <br>
        @endif

        {{ $data['tgl1'] }} - {{ $data['tgl2'] }}
    </h3>
    <div style="border:1px solid; margin: 10px"></div>
    <table class="lap">
        <thead>
            <tr>
                <th rowspan="2">No</th>
                <th rowspan="2">Petugas</th>
                <th rowspan="2">No. Transaksi</th>
                <th rowspan="2">Pelanggan</th>
                <th rowspan="2">Tanggal</th>
                <th rowspan="2">Transaksi</th>
                <th rowspan="2">Kurir</th>
                <th rowspan="2">Jumlah</th>
                <th rowspan="2">Diskon</th>
                <th rowspan="2">Ongkir</th>
                <th colspan="2">Pembayaran</th>


                <th rowspan="2">Total</th>

            </tr>
            <tr>
                <th>Cash</th>
                <th>Transfer</th>
            </tr>
        </thead>
        <tbody>
            @php
                $jumttl = [];
                $ongttl = [];
                $ttl = [];
                $ttlc = [];
                $ttlt = [];
            @endphp
            @forelse ($transaksi as $t)
                @php
                    $jumttl[] = $t->jumlah;
                    $ongttl[] = $t->ongkir;
                    $ttl[] = $t->total;
                    $ttlc[] = $t->via_bayar == 'K' ? $t->total : '';
                    $ttlt[] = $t->via_bayar == 'T' ? $t->total : '';
                @endphp
                <tr>
                    <td class="text-center">{{ $no++ }}</td>
                    <td>{{ $t->user->nm_user }}</td>
                    <td>{{ $t->kd_transaksi }}</td>
                    <td>{{ $t->member->nm_member }}</td>
                    <td>{{ tgl_time($t->created_at) }}</td>
                    <td>{!! $t->jns_transaksi == 'OFF'
                        ? '<span class="text-danger">Offline</span>'
                        : '<span class="text-success">Online</span>' !!}
                    </td>
                    <td>
                        @if ($t->sts_antar == 'Y')
                            <span class="text-primary">{{ $t->kurir->karyawan->nm_karyawan }}</span>
                        @else
                            Ambil Di Toko
                        @endif
                    </td>

                    <td class="text-right">{{ number_format($t->jumlah, 0, ',', '.') }},-</td>
                    <td class="text-center">{{ number_format($t->diskon, 0, ',', '.') }}%</td>
                    <td class="text-right">{{ number_format($t->ongkir, 0, ',', '.') }},-</td>
                    <td class="text-right">
                        {{ $t->via_bayar == 'K' ? number_format($t->total, 0, ',', '.') . ',-' : 0 }}
                    </td>
                    <td class="text-right">
                        {{ $t->via_bayar == 'T' ? number_format($t->total, 0, ',', '.') . ',-' : 0 }}
                    </td>


                    <td class="text-right">{{ number_format($t->total, 0, ',', '.') }},-</td>
                </tr>
            @empty
                <tr>
                    <td colspan="17" class="text-center">Data tidak ditemukan</td>
                </tr>
            @endforelse

        @empty(!array_sum($jumttl))
            <tr style="background-color: rgb(241, 210, 210)">

                <td class="text-center" style="font-size:17px; font-weight: bold" colspan="9">Jumlah Total</td>
                <td class="text-right" style="font-size:17px; font-weight: bold">
                    {{ number_format(array_sum($ongttl), 0, ',', '.') }},-
                </td>
                <td class="text-right" style="font-size:17px; font-weight: bold">
                    {{ number_format(array_sum($ttlc), 0, ',', '.') }},-
                </td>
                <td class="text-right" style="font-size:17px; font-weight: bold">
                    {{ number_format(array_sum($ttlt), 0, ',', '.') }},-
                </td>

                <td class="text-right" style="font-size:17px; font-weight: bold">
                    {{ number_format(array_sum($ttl), 0, ',', '.') }},-
                </td>
            </tr>
        @endempty

    </tbody>
</table>

</div>
